/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.client.DynamicLightingHandler;
import org.infernalstudios.infernalexp.config.gui.screens.ConfigScreen;
import org.infernalstudios.infernalexp.events.ClientEvents;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.items.WhipItem;

@OnlyIn(value=Dist.CLIENT)
public class InfernalExpansionClient {
    public static void init(Consumer<Runnable> enqueueWorkConsumer) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ConfigScreen()));
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MinecraftForge.EVENT_BUS.addListener(event -> DynamicLightingHandler.tick(event.getEntity()));
        enqueueWorkConsumer.accept(InfernalExpansionClient::threadSafeInit);
    }

    private static void threadSafeInit() {
        ItemProperties.register((Item)((Item)IEItems.GLOWSILK_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientWorld, livingEntity, ticks) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)((Item)IEItems.GLOWSILK_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientWorld, livingEntity, entityId) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)IEItems.BLINDSIGHT_TONGUE_WHIP.get()), (ResourceLocation)new ResourceLocation("attack_frame"), (itemStack, clientWorld, livingEntity, entityId) -> livingEntity == null || livingEntity.m_21205_() != itemStack && livingEntity.m_21206_() != itemStack ? 0.0f : (float)((int)((float)((WhipItem)itemStack.m_41720_()).getTicksSinceAttack(itemStack) / 3.0f)));
        ItemProperties.register((Item)((Item)IEItems.BLINDSIGHT_TONGUE_WHIP.get()), (ResourceLocation)new ResourceLocation("attacking"), (itemStack, clientWorld, livingEntity, entityId) -> !(livingEntity == null || !((WhipItem)itemStack.m_41720_()).getAttacking(itemStack) && !((WhipItem)itemStack.m_41720_()).getCharging(itemStack) || livingEntity.m_21205_() != itemStack && livingEntity.m_21206_() != itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)IEItems.KINETIC_TONGUE_WHIP.get()), (ResourceLocation)new ResourceLocation("attack_frame"), (itemStack, clientWorld, livingEntity, entityId) -> livingEntity == null || livingEntity.m_21205_() != itemStack && livingEntity.m_21206_() != itemStack ? 0.0f : (float)((int)((float)((WhipItem)itemStack.m_41720_()).getTicksSinceAttack(itemStack) / 3.0f)));
        ItemProperties.register((Item)((Item)IEItems.KINETIC_TONGUE_WHIP.get()), (ResourceLocation)new ResourceLocation("attacking"), (itemStack, clientWorld, livingEntity, entityId) -> !(livingEntity == null || !((WhipItem)itemStack.m_41720_()).getAttacking(itemStack) && !((WhipItem)itemStack.m_41720_()).getCharging(itemStack) || livingEntity.m_21205_() != itemStack && livingEntity.m_21206_() != itemStack) ? 1.0f : 0.0f);
        InfernalExpansionClient.loadInfernalResources();
    }

    public static void loadInfernalResources() {
        File dir = new File(".", "resourcepacks");
        File target = new File(dir, "Infernal Resources.zip");
        if (!target.exists()) {
            try {
                dir.mkdirs();
                InputStream in = InfernalExpansion.class.getResourceAsStream("/assets/infernalexp/infernal_resources.zip");
                FileOutputStream out = new FileOutputStream(target);
                byte[] buf = new byte[16384];
                int len = 0;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

